/***************************************************************************
 *
 * Copyright (C) 2001 International Business Machines
 * All rights reserved.
 *
 * This file is part of the GPFS mmfslinux kernel module.
 *
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions 
 * are met:
 *
 *  1. Redistributions of source code must retain the above copyright notice, 
 *     this list of conditions and the following disclaimer. 
 *  2. Redistributions in binary form must reproduce the above copyright 
 *     notice, this list of conditions and the following disclaimer in the
 *     documentation and/or other materials provided with the distribution. 
 *  3. The name of the author may not be used to endorse or promote products 
 *     derived from this software without specific prior written
 *     permission. 
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES 
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; 
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *************************************************************************** */
/*
 * Interface definitions for basic common services, platform independent
 * version. Interfaces in the first section of this file may be used by code
 * running either in a process or in the kernel, while interfaces defined
 * in the second section of this file may only be used by code running in the
 * kernel.
 *
 * Process and kernel interfaces:
 *   cxiGetThreadId - get thread identifier
 *
 * Kernel-only memory allocation services:
 *   void* cxiMallocPinned(int nBytes)
 *   void* cxiMallocUnpinned(int nBytes)
 *   void cxiFreePinned(void* p)
 *   void cxiFreeUnpinned(void* p)
 *
 * Kernel-only interfaces:
 *   cxiIsSuperUser - return true if caller has maximum authorization
 *   cxiGetMaxFileSize - return the maximum file size the calling process
 *     is allowed to create.  A value of cxiUnlimitedFileSize means file
 *     sizes are not limited.
 *   cxiUiomove - transfer data from buffer(s) in user space to or from
 *     a buffer in the kernel.
 *
 */

/* $Id: cxiSystem.h,v 1.60 2002/04/16 23:23:50 schmuck Exp $
 *
 * $Log: cxiSystem.h,v $
 * Revision 1.60  2002/04/16 23:23:50  schmuck
 * Fix another bug in multi-node delete-on-last-close on Linux:
 * If a file is accessed on Node A, renamed on Node B, and then deleted on
 * Node B, an invalidated dcache entry referring to the old name of the
 * file was left over on Node A, preventing the file from being destroyed.
 *
 * Revision 1.59  2001/10/24 18:13:31  dcraft
 * Defect 352112: Be more systematic about kproc startup and end.  Let
 * keventd spawn the kernel threads in linux so we can signal him to
 * reap them.
 *
 * Revision 1.58  2001/09/22 20:10:25  dcraft
 * Remove kiobufs from cxiKernelIODescriptor_t.  Use temporary
 * kiobufs for map/unmap.   Remove dead code and dead comments
 * in portability layer and update readmes and license.
 * Fix traceback to appear in mmfs.log file.
 *
 * Revision 1.57  2001/09/12 05:45:55  schmuck
 * On ACL changes, permission information cached in the Linux inode
 * was not being updated correctly.
 *
 * Revision 1.56  2001/09/06 14:00:37  dixonbp
 * Move lock owner from cxiFcntlLock args and add it to cxiFlock_t.
 *
 * Revision 1.55  2001/07/19 23:25:24  dcraft
 * Modified linux trace to allow non blocking trace record
 * writes (format is TRACE?N).  New gpfs swapd process created
 * which is responsible for reclaiming inodes (5 percent every
 * time it runs).  Marked all our inodes so that they would be
 * ignored by linux kswapd.  Added "unused" inode to inode
 * cache that could be used as a signal that linux kswapd is
 * running and kick off gpfs swapd.  Added means to ignore attempts
 * to kill mmfsd by kswapd if the system gets low on memory.
 * All done in an attempt to avoid kswapd premature wakeup on simple
 * locks and mutexes.
 *
 * Revision 1.54  2001/07/13 19:55:55  wyllie
 * Get PAGE_OFFSET by asking the mmfslinux_... kernel module rather than
 * compiling the constant into proprietary code.  Rename constants needed to
 * determine the GPFS memory map and export them to non-proprietary files.
 *
 * Revision 1.53  2001/06/06 21:56:03  wyllie
 * Change the way NFSData objects are timed out.  Instead of using watchdog
 * timers that enqueue NFSData objects at interrupt level for later
 * processing by the NFS watchdog kernel process, just let the watchdog
 * process wake up periodically and examine its LRU list of NFSData objects
 * to decide which should be closed.  This fixes a bug on Linux that shows
 * up as the assert "nfsP->nextWatchP == NFS_WATCH_NOT_QUEUED" under high
 * load.  This also allows deleting a bunch of cxiXXX interfaces dealing
 * with watchdog timers.
 *
 * Revision 1.52  2001/05/12 18:38:33  schmuck
 * Fix problem with NFS returning spurious errors under load.
 *
 * Revision 1.51  2001/05/11 20:12:18  eshel
 * Cleanup some GPFS_LINUX ifdefs.
 *
 * Revision 1.50  2001/05/09 23:05:39  eshel
 * Use malloc for gpfsNode if it is to big for the linux inode.
 *
 * Revision 1.49  2001/05/04 18:13:36  eshel
 * Storing the gnode inside the linux inode.
 *
 * Revision 1.48  2001/05/02 20:45:33  eshel
 * Make sure the all OS nodes are invalidated before auto remount.
 *
 * Revision 1.47  2001/04/24 23:12:05  eshel
 * Add the KXIVO_DESTROY flag to tell kxInvalidateOSNode() to set i_nlink in the
 * linux inode to zero on from MNodeToken::token_revoke() with the
 * CTM_A_BEING_DESTROYED on. The file is being destroyed.
 *
 * Revision 1.46  2001/04/23 22:17:33  jpalmer
 * Fix oplock hang by locating open file for ftruncInternal
 *
 * Revision 1.45  2001/04/16 21:02:53  eshel
 * Add option to update file size under a spin_lock and only if it is bigger.
 *
 * Revision 1.44  2001/04/09 23:27:58  eshel
 * update time changes in OS node (no nanoseconds for now)
 *
 * Revision 1.43  2001/04/09 21:06:28  eshel
 * Add code to keep OS node (linux inode) attributes up to date.
 *
 * Revision 1.42  2001/04/08 22:18:43  dcraft
 * Fix multinde delete race conditions.  Still incomplete.
 *
 * Revision 1.41  2001/04/05 07:44:19  manoj
 * Remove prototype for cxiSMBOpenLockControl (already defined in oplock.h)
 *
 * Revision 1.40  2001/04/04 22:33:04  eshel
 * change kxInvalidateOSNode to also update linux inode
 *
 * Revision 1.39  2001/03/30 01:05:43  jpalmer
 * Add SMBopen lock functions for NLM interface
 *
 * Revision 1.38  2001/03/27 17:13:57  eshel
 * remove unused code
 *
 * Revision 1.37  2001/03/26 18:30:31  dcraft
 * Update inode attributes in OS node layer via callback to cxiSetOSNode
 * (previous setInode).  The attributes are now updated during kSFSGetattr()
 * while the lock is held to ensure validity.
 *
 * Revision 1.36  2001/03/14 00:36:57  eshel
 * add cxiSetInode() to call setInode()
 *
 * Revision 1.35  2001/03/09 16:45:07  jpalmer
 * SMB Locking - remove old dfs Interops functions
 *
 * Revision 1.34  2001/03/07 00:50:00  eshel
 * remove unused code
 *
 * Revision 1.33  2001/03/05 23:28:22  dcraft
 * Modify inode and gpfsNode reference management.  Inode is now acquired
 * during gpfsNode creation and must be released via cxiPutOSNode().
 * (documented in gpfs database).  Add "mmfsadm dump vnodes" for producing
 * trace info on all held inodes.
 *
 * Revision 1.32  2001/03/02 22:44:17  jpalmer
 * SMB Locking function: user communications
 *
 * Revision 1.31  2001/02/09 06:32:31  mcnabb
 * Ifdef cxiInvalidateInode for Linux only. Doesn't compile on AIX.
 *
 * Revision 1.30  2001/02/08 18:04:57  schmuck
 * Tweak fast path through gpfs_i_permission for files that don't have
 * extended acls: instead of doing the check in gpfs_i_permission,
 * set inode_operations::permission to NULL so Linux will do the check
 * without invoking gpfs_i_permission.
 * No functional change.
 *
 * Revision 1.29  2001/01/27 15:42:53  dixonbp
 * New parameter to cxiCloseNFS.
 *
 * Revision 1.28  2001/01/12 02:56:57  eshel
 * Add code for read by inode.
 *
 * Revision 1.27  2000/12/15 13:57:08  gjertsen
 * Clean up documentation.
 *
 * Revision 1.26  2000/12/12 20:23:12  gjertsen
 * Make picky IA64 compiler happy in 1002 gnu toolchain.
 *
 * Revision 1.25  2000/12/09 20:33:39  schmuck
 * Instead of setting/checking flags to invalidate/revalidate dcache entries,
 * simply set dentry::d_ops to point to different dentry_operations tables:
 * one where the d_revalidate field is NULL (means the dentry is valid),
 * and one where d_revalidate points at a function that always returns false
 * (means the dentry is invalid).
 *
 * Revision 1.24  2000/12/08 22:16:07  schmuck
 * Add a call to invalidate negative dcache entries when a directory
 * byte-range token is relinquished.  This allows gpfs_d_revalidate
 * to return the correct answer for negative dcache entries, avoiding
 * an extra call to lookup.
 *
 * Revision 1.23  2000/11/08 15:27:21  gjertsen
 * Further cleanup linux build warnings.
 *
 * Revision 1.22  2000/11/07 00:22:45  eshel
 * Add code to support remount.
 *
 * Revision 1.21  2000/10/26  15:10:56  dixonbp
 * Create cxiFcntlUnblock to cleanup after an fcntl lock wait
 * is interrupted.
 *
 * Revision 1.20  2000/10/19  19:10:26  dixonbp
 * Prototypes for nfs/watchdog functions.
 *
 * Revision 1.19  2000/08/29  18:33:00  dcraft
 * Now produce mmfs module.
 *
 * Revision 1.18  2000/08/28  14:15:00  gjertsen
 * Use C wrapper functions for C++ class methods in
 * cxi interface. Convert all cxi functions to C interface.
 *
 * Revision 1.17  2000/08/21  22:15:59  dcraft
 * Create cxiDev_t type that is based on user level dev_t.  Provide
 * mapping functions between kernel, user, and inode device field.
 * Fix NLS yes/no query.
 *
 * Revision 1.16  2000/08/10  18:51:58  dixonbp
 * Add cxiVFSToFlock and cxiFlockToVFS routines to convert from
 * generic cxiFlock_t to platform specific fcntl locking structs.
 *
 * Revision 1.15  2000/07/20  15:49:30  dcraft
 * Abstract event words for OS independence
 *
 * Revision 1.14  2000/07/11  19:31:52  dcraft
 * gpfsNode_t::findOrCreate no longer creates an OS specific node on
 * linux.  This caused coding problems since gpfsNode release cannot call
 * iput() itself nor can it decrement the i_count.  The inode is gotten
 * at the vfs specific layer thereby guaranteeing that linux will be
 * responsible for the iput() and i_count decrement.
 *
 * Revision 1.13  2000/07/11  16:35:53  wyllie
 * Use cxiUio_t instead of struct uio.  Use cxiUiomove instead of uiomove.  Use
 * CXI_READ instead of UIO_READ, etc.
 *
 * Revision 1.12  2000/06/30  16:22:19  wyllie
 * Use cxiNode_t typedef instead of struct cxiNode_t.
 *
 * Revision 1.11  2000/06/26  14:43:11  dixonbp
 * Add cxiTrace.
 *
 * Revision 1.10  2000/06/23  20:31:36  dcraft
 * Remove sysdep.h and ModeBits.h.  Pare down some OS specific
 * header includes.  Use cxiMode_t instead of mode_t due to
 * linux short mode_t in kernel.
 *
 * Revision 1.9  2000/06/20  23:53:47  dcraft
 * Remove OS specifics from mmfsnode.C and mmfsnode.h. Remove sharkvfs.h.
 * Remove unnecessary OS specific ifdefs of header files.
 *
 * Revision 1.8  2000/06/16  20:32:56  dcraft
 * Split MMFSNode into cxiNode_t containing OS dependent items
 * (such as gnode) and gpfsNode_t OS independent items.  Acquire
 * inodes during creation of gpfsNodes.  Remove __FULL_PROTO and
 * system prototypes from all C files.  Turn on __FULL_PROTO in
 * site.mcr.
 *
 * Revision 1.7  2000/06/13  14:49:58  dixonbp
 * Move cxiFcntlLock here from cxiSystem-plat and add cxiFcntlReset.
 *
 * Revision 1.6  2000/06/12  19:32:24  dcraft
 * Rename SharkPrivateVFSData to gpfsVFSData_t and split off into OS independent
 * vfsdata.h.   OS dependent layer relies only on forward declaration gpfsVFSData_t
 * since it uses it only as a pointer (hence the non cxi name).
 *
 * Revision 1.5  2000/06/05  19:01:27  dcraft
 * Complete mount callbacks within the OS dependent kernel extension.
 * Record vfs number in gpfsVfsData_t.
 *
 * Revision 1.4  2000/05/30  21:30:07  wyllie
 * Move types from cxiSystemTypes.h to cxiTypes.h.  Use cxi prefix instead of kxi.
 *
 * Revision 1.3  2000/05/26  23:35:39  wyllie
 * Use cxiIsSuperUser() instead of getuidx(ID_REAL)==0. Use cxiGetMaxFileSize()
 * instead of getfslimit().
 *
 * Revision 1.2  2000/05/23  16:19:46  gjertsen
 * Added definitions for common (kernel and daemon) system types.
 * Cleaned up use of pid_t and key_t in code with new types.
 *
 * Revision 1.1  2000/05/19  23:18:47  wyllie
 * Add files to define common (kernel and daemon) types and interfaces.  Move
 * some of the basic types from Shark.h to cxiTypes.h, which is included by
 * Shark.h.
 *
 */

#ifndef _h_cxiSystem
#define _h_cxiSystem

#include <cxiTypes.h>

/* Prototypes for OS dependent entry points called by GPFS.
 * If any of these should become macros for certain OSes then
 * this definition will have to move into the platform specific
 * system file.
 */
#ifdef __cplusplus
extern "C"
{
#endif /* __cplusplus */

int cxiFindOSNode(void *osVfsP, struct cxiNode_t *, void **osNodePP,
                  Boolean);
int cxiNewOSNode(void *osVfsP, struct cxiNode_t **, void **osNodePP,
                 cxiIno_t, int, void *opaqueP);
int cxiReactivateOSNode(void *osVfsP, struct cxiNode_t *, void **osNodePP);

int cxiRefOSNode(void *osVfsP, struct cxiNode_t *, void *osNodeP, int);
int cxiInactiveOSNode(void *osVfsP, struct cxiNode_t *, void *osNodeP,
                      Boolean *, Boolean *);

void cxiRemoveOSNodeUnused();
int  cxiAddOSNodeUnused();

void cxiPutOSNode(void *vP);
void cxiDestroyOSNode(void *vP);
void cxiDumpOSNode(struct cxiNode_t *);
void cxiFreeOSNode(void *osVfsP, struct cxiNode_t *, void *osNodeP);
void cxiReinitOSNode(void *osVfsP, struct cxiNode_t *, void *osNodeP);
int  cxiInvalidateDCacheEntry(cxiNode_t *cnP);
int  cxiInvalidateDCacheEntryNoPrune(cxiNode_t *cnP);
void cxiDropInvalidDCacheEntries(cxiNode_t *cnP);
int  cxiInvalidateNegDCacheEntries(cxiNode_t *cnP);
void cxiInvalidatePerm(cxiNode_t *cnP);
void cxiUpdateInode(cxiNode_t *cnP, cxiVattr_t *attrP, int what);

void cxiSetOSNodeType(cxiNode_t *cnP, cxiMode_t mode, cxiDev_t dev);
void cxiSetOSNode(void *osVfsP, cxiNode_t *cnP, cxiVattr_t *vattrP);

int cxiSetMountInfo(void *osVfsP, cxiDev_t, int bsize, void *osRootNodeP,
                    struct cxiNode_t *cnRootP, Boolean *releRootP,
                    void *gnRootP);
int cxiIsVfsMounted(void *osVfsP);

int cxiFcntlLock(void *fP, int cmd, void *flP,
                 cxiFlock_t *flockP, int (*retryCB)(),
                 cxiOff64_t size, cxiOff64_t offset,
                 unsigned long *retry_idP);
int cxiFcntlReset(void *vfsP, cxiPid_t mmfsd_pid);
void cxiFcntlUnblock(void *retry_idP);
int cxiTrace(cxiTrace_t trace);
void cxiFlockToVFS(eflock_t* lckdatP, void* vP);
void cxiVFSToFlock(void *vP, eflock_t* lckdatP);

void cxiOpenNFS(void *vP);
int cxiCloseNFS(void *vP, void *viP);

void *cxiGetNfsP(void *vP);
void  cxiSetNfsP(void *vP, void *newP);
void *cxiGetCnP(void *vP);
void *cxiGetPvP(void *vP);
void *cxiGNPtoVP(void *vP);
void *cxiGetPrivVfsP(void *vP);

void cxiSetProcessGroup();
void cxiSetProcessName(char *nameP);
#ifdef _KERNEL
cxiPid_t cxiStartKProc(struct cxiKProcData_t *);
void cxiStopKProc(struct cxiKProcData_t *);
#endif
void cxiSleep(int ms);

#ifdef SMB_LOCKS
void *cxiCheckOpen(struct cxiNode_t* cnP);
#endif

/* Insure that our type definitions match any OS definitions */
int cxiCheckTypes();

#ifdef __cplusplus
}
#endif /* __cplusplus */

/* Values for 'what' parameter to cxiUpdateInode and statUpdateOSNode:
   Selectively updated the OS node attributes. */
#define CXIUP_NLINK    0x00000001   /* update nlink */
#define CXIUP_MODE     0x00000002   /* update mode and ctime */
#define CXIUP_OWN      0x00000004   /* update mode,uid,gid and ctime */
#define CXIUP_SIZE     0x00000008   /* update fsize */
#define CXIUP_SIZE_BIG 0x00000010   /* update fsize if bigger */
#define CXIUP_TIMES    0x00000020   /* update all times */
#define CXIUP_ATIME    0x00000040   /* update atime only, other flags are not
                                         checked */
#define CXIUP_PERM     0x00000080   /* update fields needed for permission
                                         checking */

#define cxiDev32Major(x) (Int32)((unsigned)(x)>>16)
#define cxiDev32Minor(x) (Int32)((x)&0xFFFF)

/* Maximum number of simultaneous threads (must be a power of 2) */
#define MAX_GPFS_THREADS 512

/* Include platform-specific versions of interfaces to common exported
   services */
#include <cxiSystem-plat.h>

#define MAX_READDIR_BUF_SIZE 65536

#endif  /* _h_cxiSystem */

